<?php
// Database configuration
$host = '173.252.167.20';
$db = 'varshate_stock_analysis';
$user = 'varshate_user1'; // Use your MySQL username
$pass = 'Chennai$001'; // Use your MySQL password


// Create connection
$conn = new mysqli($host, $user, $pass, $db);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Your API Key
$apiKey = 'YOUR_API_KEY'; // Replace with your Alpha Vantage API key
$stockSymbols = ['AAPL', 'GOOGL', 'MSFT']; // List of stocks to fetch

foreach ($stockSymbols as $symbol) {
    // Fetch stock data from API
    $url = "https://www.alphavantage.co/query?function=TIME_SERIES_DAILY&symbol=$symbol&apikey=$apiKey";
    $response = file_get_contents($url);
    $data = json_decode($response, true);

    // Get the most recent stock data
    $latestDay = key($data['Time Series (Daily)']);
    $latestData = $data['Time Series (Daily)'][$latestDay];

    // Prepare SQL statement
    $stmt = $conn->prepare("INSERT INTO stocks (symbol, company_name, price, high, low, volume) VALUES (?, ?, ?, ?, ?, ?)
                             ON DUPLICATE KEY UPDATE price = VALUES(price), high = VALUES(high), low = VALUES(low), volume = VALUES(volume)");
    $companyName = $symbol; // You can implement a function to get real company names

    $stmt->bind_param("ssdddi", $symbol, $companyName, $latestData['4. close'], $latestData['2. high'], $latestData['3. low'], $latestData['5. volume']);
    $stmt->execute();
}

$stmt->close();
$conn->close();

echo "Stock data updated successfully.";
?>